//**************************************************************************************
//**************************************************************************************
//****																				****
//****						  Digitalanzeige.C										****
//****																				****
//****			Digitalanzeige fr Magnetmesssystem auf Basis						****
//****			AS5311 von Austriamicrosystems mit S65 Display						****
//****			copyrigth (c) 2010 by Dipl. Ing. Steffen Taubmann					****
//****																				****
//****			Kontakt: steffenta@gmx.de											****
//****																				****
//**************************************************************************************
//****		 																		****
//****	Fr private Anwender gilt:													****
//****		 																		****
//****		Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen ****
//****		der GNU General Public License, wie von der Free Software Foundation 	****
//****		verffentlicht, weitergeben und/oder modifizieren, entweder gem 		****
//****		Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren Version.	****
//****																				****
//****		Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es	****
//****		Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne	****
//****		die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN	****
//****		BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.	****
//****		 																		****
//****		Sie sollten ein Exemplar der GNU General Public License zusammen mit	****
//****		diesem Programm erhalten haben. 										****
//****		Falls nicht, siehe <http://www.gnu.org/licenses/>.						****
//****																				****
//****	Die kommerzielle Verwendung des Quellcodes bedarf generell der Genehmigung	****
//****	des Autors. Mit kommerzieller Verwendung ist der Verkauf von auf diesem		****
//****	Code basierenden Systemen zu verstehen. Der Einsatz des Systems in einem	****
//****	kommerziellen Umfeld ist davon nicht betroffen.								****
//****																				****
//**************************************************************************************
//**************************************************************************************

#define P18F4620
//#define Debug

#include <18F4620.h>
#include <18F4620_FSR.h>

#ifdef Debug
	#device ADC=10 ICD=TRUE
#else
	#device ADC=10
#endif

#use delay(clock=16000000, restart_wdt)


#define CONFIG1 _OSC_INTIO67_1H & _FCMEN_OFF_1H & _IESO_OFF_1H
#define CONFIG3 _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H & _CCP2MX_PORTC_3H
#ifdef Debug
  #define CONFIG2 _PWRT_OFF_2L & _BOREN_OFF_2L & _BORV_2_2L & _WDT_OFF_2H & _WDTPS_64_2H
  #define CONFIG4 _STVREN_ON_4L & _LVP_OFF_4L & _XINST_OFF_4L
  #define CONFIG5 _CP0_OFF_5L & _CP1_OFF_5L & _CP2_OFF_5L & _CP3_OFF_5L & _CPB_OFF_5H & _CPD_OFF_5H
  #define CONFIG6 _WRT0_OFF_6L & _WRT1_OFF_6L & _WRT2_OFF_6L & _WRT3_OFF_6L & _WRTB_OFF_6H & _WRTC_OFF_6H & _WRTD_OFF_6H
#else
  #define CONFIG2 _PWRT_ON_2L & _BOREN_NOSLP_2L & _BORV_2_2L & _WDT_OFF_2H & _WDTPS_64_2H
  #define CONFIG4 _DEBUG_ON_4L & _STVREN_ON_4L & _LVP_OFF_4L & _XINST_OFF_4L
  #define CONFIG5 _CP0_ON_5L & _CP1_ON_5L & _CP2_ON_5L & _CP3_ON_5L & _CPB_ON_5H & _CPD_OFF_5H
  #define CONFIG6 _WRT0_OFF_6L & _WRT1_OFF_6L & _WRT2_OFF_6L & _WRT3_OFF_6L & _WRTB_ON_6H & _WRTC_ON_6H & _WRTD_OFF_6H
#endif
#define CONFIG7 _EBTR0_OFF_7L & _EBTR1_OFF_7L & _EBTR2_OFF_7L & _EBTR3_OFF_7L & _EBTRB_OFF_7H
#rom 0x300000={CONFIG1,CONFIG2,CONFIG3,CONFIG4,CONFIG5,CONFIG6,CONFIG7}
#rom 0xF00000={5,10,2,0}						// EEPROM Parameter
#define DezimalDigits2							// Anzeige von zwei Dezimalstellen, sonst 3

#include "global.h"								// Globale Symboldefinitionen
#include "HD66773_defs.h"						// Displayansteuerung
#include "RS485.h"								// RS485-Routinen
#include "Interrupt.h"							// Interruptroutinen
#include "functions.h"							// sonstige Funktionen
#include "MMS_Sensors.h"						// Sensoransteuerung
#include "LCD.h"								// LCD Darstellungen etc.

void main()
{ int Taste;
  int32 V;

  InitPic();					// Initialisierungssequenzen
  ReadParameter();				// Parameter aus EEPROM lesen
  XSOffset=XOffset*2048;
  YSOffset=YOffset*2048;
  ZSOffset=ZOffset*2048;
	ValueToMM(LCDStr,V);


  LCDPowerOn();					// PowerOn Sequenz
  LCDDisplayOn();				// Display On
  ShowScreen(0);

  while(true)
  { #asm clrwdt	#endasm
	// ---------------- Serielle Komunikation ----------------

	if (_DatenEmpfangen)
	{// DatensatzAuswerten();
	 // falls bergeordnetes System angeschlossen
	 // for future use
	  _DatenEmpfangen=false;
	}

	// ---------------- Tastaturabfrage ----------------

	if (_TastAbfrage)
	{ Taste=GetTaste();
	  _TastAbfrage=false;
	}

	if (SysMode==0)				// Messwertanzeige
	{
	// ---------------- Sensoren abfragen ----------------

	  if (_MesswertAbfrage)
	  { GetAndShowValue(0);			// X Messwert
	    GetAndShowValue(1);			// Y Messwert
	    GetAndShowValue(2);			// Z Messwert
	    // GetAndShowValue(10);			// Drehzahl
	    _MesswertAbfrage=false;
 	  }
	
	// ---------------- Funktionstaste gedrckt ----------------
	if(Taste==2) MMS_ResetSystem(0);	// X-setzen?
	if(Taste==3) MMS_ResetSystem(1);	// Y-setzen?
	if(Taste==4) MMS_ResetSystem(2);	// Z-setzen?


	// ---------------- Umschaltung auf Parametrierung ----------------
	  if(Taste==1)
	  { SysMode=1;
		ShowScreen(1);
		While(GetTaste()!=0) Restart_wdt();	// warten, bis Taste wieder losgelassen
	  }
	} // if (AktMode==0)

	if (SysMode==1)					// Parametrierung
	{ ChangeParams();
	} // if (AktMode==1)
 }
}
   